/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat.iris_compatibility;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.compat.IPPortingLibCompat;
import qouteall.imm_ptl.core.compat.iris_compatibility.IPIrisHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalRenderInfo;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.SecondaryFrameBuffer;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.imm_ptl.core.render.renderer.PortalRenderer;

public class IrisCompatibilityPortalRenderer
extends PortalRenderer {
    public static final IrisCompatibilityPortalRenderer instance = new IrisCompatibilityPortalRenderer(false);
    public static final IrisCompatibilityPortalRenderer debugModeInstance = new IrisCompatibilityPortalRenderer(true);
    private SecondaryFrameBuffer deferredBuffer = new SecondaryFrameBuffer();
    private Matrix4f passingModelView = new Matrix4f();
    public boolean isDebugMode;

    public IrisCompatibilityPortalRenderer(boolean isDebugMode) {
        this.isDebugMode = isDebugMode;
    }

    @Override
    public boolean replaceFrameBufferClearing() {
        client.method_1522().method_1235(false);
        return false;
    }

    @Override
    public void onBeforeTranslucentRendering(Matrix4f modelView) {
        if (PortalRendering.isRendering()) {
            return;
        }
        this.passingModelView = modelView;
        GL11.glDisable((int)2960);
    }

    @Override
    public void onAfterTranslucentRendering(Matrix4f modelView) {
    }

    @Override
    public void finishRendering() {
        GL11.glDisable((int)2960);
    }

    @Override
    public void prepareRendering() {
        this.deferredBuffer.prepare();
        this.deferredBuffer.fb.method_1236(1.0f, 0.0f, 0.0f, 0.0f);
        this.deferredBuffer.fb.method_1230(class_310.field_1703);
        IPPortingLibCompat.setIsStencilEnabled(client.method_1522(), false);
        client.method_1522().method_1235(false);
    }

    protected void doRenderPortal(Portal portal, Matrix4f modelView) {
        if (PortalRendering.isRendering()) {
            return;
        }
        if (!this.testShouldRenderPortal(portal, modelView)) {
            return;
        }
        client.method_1522().method_1235(true);
        PortalRendering.pushPortalLayer(portal);
        this.renderPortalContent(portal);
        PortalRendering.popPortalLayer();
        CHelper.enableDepthClamp();
        if (!this.isDebugMode) {
            this.deferredBuffer.fb.method_1235(true);
            MyRenderHelper.drawPortalAreaWithFramebuffer(portal, client.method_1522(), modelView, RenderSystem.getProjectionMatrix());
        } else {
            this.deferredBuffer.fb.method_1235(true);
            MyRenderHelper.drawScreenFrameBuffer(client.method_1522(), true, true);
        }
        CHelper.disableDepthClamp();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        client.method_1522().method_1235(true);
    }

    @Override
    public void invokeWorldRendering(WorldRenderInfo worldRenderInfo) {
        MyGameRenderer.renderWorldNew(worldRenderInfo, Runnable::run);
    }

    @Override
    public void renderPortalInEntityRenderer(Portal portal) {
    }

    private boolean testShouldRenderPortal(Portal portal, Matrix4f modelView) {
        this.deferredBuffer.fb.method_1235(true);
        return PortalRenderInfo.renderAndDecideVisibility(portal, () -> ViewAreaRenderer.renderPortalArea(portal, class_243.field_1353, modelView, RenderSystem.getProjectionMatrix(), true, false, false, true));
    }

    @Override
    public void onBeforeHandRendering(Matrix4f modelView) {
        if (PortalRendering.isRendering()) {
            return;
        }
        CHelper.checkGlError();
        IPIrisHelper.newCopyDepthStencil(client.method_1522(), (class_276)this.deferredBuffer.fb);
        IPIrisHelper.copyColor(client.method_1522(), (class_276)this.deferredBuffer.fb);
        CHelper.checkGlError();
        this.renderPortals(this.passingModelView);
        class_276 mainFrameBuffer = client.method_1522();
        mainFrameBuffer.method_1235(true);
        MyRenderHelper.drawScreenFrameBuffer((class_276)this.deferredBuffer.fb, false, false);
    }

    @Override
    public void onHandRenderingEnded() {
    }

    protected void renderPortals(Matrix4f modelView) {
        List<Portal> portalsToRender = this.getPortalsToRender(modelView);
        for (Portal portal : portalsToRender) {
            this.doRenderPortal(portal, modelView);
        }
    }
}

